#include "stdafx.h"
#include "win_demo.h"
#include "win_demoDlg.h"
#include "afxdialogex.h"
#include "cJSON.h"
#include "sdks.h"
#include "sdks_media.h"
#include "sys_pthread.h"
#include "perser_json.h"
#include "pack_json.h"
#include "common_struct.h"
#include "DialogStreamParam.h"
#include "DialogOSDParam.h"
#include "DialogNetParam.h"
#include "DialogPortParam.h"
#include "DialogAlarmParam.h"
#include "DialogMultiobjParam.h"
#include "DialogMaintenance.h"
#include "DialogThermalParam.h"
#include "DialogPlayback.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ֧

// ʵ
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


CButton m_video;
Cwin_demoDlg::Cwin_demoDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_WIN_DEMO_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void Cwin_demoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_IP, m_ip);
	DDX_Control(pDX, IDC_EDIT_PORT, m_port);
	DDX_Control(pDX, IDC_EDIT_CHN, m_chn);
	DDX_Control(pDX, IDC_EDIT_USER, m_user);
	DDX_Control(pDX, IDC_EDIT_PASSWD, m_passwd);
	DDX_Control(pDX, IDC_BTN_VIDEO, m_video);
	DDX_Control(pDX, IDC_BTN_CON, m_connnect);
	DDX_Control(pDX, IDC_BTN_CLOSE, m_close);
	DDX_Control(pDX, IDC_BTN_PLAY, m_mainplay);
	DDX_Control(pDX, IDC_BTN_STOP, m_mainstop);
	DDX_Control(pDX, IDC_BTN_PTZZoomin, m_ptzzoomin);
	DDX_Control(pDX, IDC_BTN_PTZZoomout, m_ptzzoomout);
	DDX_Control(pDX, IDC_BTN_PTZFocusin, m_ptzfocusin);
	DDX_Control(pDX, IDC_BTN_PTZFocusout, m_ptzfocusout);
	DDX_Control(pDX, IDC_BTN_PTZFocusAuto, m_ptzfocusauto);
	DDX_Control(pDX, IDC_CBUT_STREAM_TYPE, m_cb_v_stream_type);
	DDX_Control(pDX, IDC_EDIT_PATH, m_filepath);
	DDX_Control(pDX, IDC_BTN_CAPTURE, m_capture);
	DDX_Control(pDX, IDC_BTN_RECORD, m_record);
	DDX_Control(pDX, IDC_BTN_STOP_RECORD, m_stop_record);
	DDX_Control(pDX, IDC_BUTTON_VIDEO_PARAM, m_video_param);
	DDX_Control(pDX, IDC_BUTTON_OSD_PARAM, m_osd_param);
	DDX_Control(pDX, IDC_CHECK_SAVE_RECOVE, m_save_record);
	DDX_Control(pDX, IDC_BTN_PTZ_IRIS_AUTO, m_ptz_iris_auto);
	DDX_Control(pDX, IDC_BTN_PTZ_IRIS_IN, m_ptz_iris_in);
	DDX_Control(pDX, IDC_BTN_PTZ_IRIS_OUT, m_ptz_iris_out);
	DDX_Control(pDX, IDC_BTN_PTZ_ROTATE_U, m_ptz_rotate_u);
	DDX_Control(pDX, IDC_BTN_PTZ_ROTATE_LU, m_ptz_rotate_lu);
	DDX_Control(pDX, IDC_BTN_PTZ_ROTATE_L, m_ptz_rotate_l);
	DDX_Control(pDX, IDC_BTN_PTZ_ROTATE_LD, m_ptz_rotate_ld);
	DDX_Control(pDX, IDC_BTN_PTZ_ROTATE_D, m_ptz_rotate_d);
	DDX_Control(pDX, IDC_BTN_PTZ_ROTATE_RD, m_ptz_rotate_rd);
	DDX_Control(pDX, IDC_BTN_PTZ_ROTATE_R, m_ptz_rotate_r);
	DDX_Control(pDX, IDC_BTN_PTZ_ROTATE_RU, m_ptz_rotate_ru);
	DDX_Control(pDX, IDC_BUTTON_NET_PARAM, m_net_param);
	DDX_Control(pDX, IDC_BUTTON_PORT_PARAM, m_port_param);
	DDX_Control(pDX, IDC_BUTTON_ALARM_PARAM, m_alarm_param);
	DDX_Control(pDX, IDC_BUTTON_MULTIOBJ_PARAM, m_multiobj_param);
	DDX_Control(pDX, IDC_BUTTON_MAINTENANCE, m_maintenance);
	DDX_Control(pDX, IDC_BUTTON_THERMAL_PARAM, m_thermal_param);
	DDX_Control(pDX, IDC_BTN_PLAYBACK, m_btn_playback);
}

BEGIN_MESSAGE_MAP(Cwin_demoDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_CHANGE(IDC_EDIT_IP, &Cwin_demoDlg::OnEnChangeEditIp)
	ON_BN_CLICKED(IDC_BTN_CON, &Cwin_demoDlg::OnBnClickedBtnCon)
	ON_BN_CLICKED(IDC_BTN_PLAY, &Cwin_demoDlg::OnBnClickedBtnPlay)
	ON_BN_CLICKED(IDC_BTN_STOP, &Cwin_demoDlg::OnBnClickedBtnStop)
	ON_BN_CLICKED(IDC_BTN_CLOSE, &Cwin_demoDlg::OnBnClickedBtnClose)
	ON_BN_CLICKED(IDC_BTN_PTZZoomin, &Cwin_demoDlg::OnBnClickedBtnPTZZoomIn)
	ON_BN_CLICKED(IDC_BTN_PTZZoomout, &Cwin_demoDlg::OnBnClickedBtnPTZZoomOut)
	ON_BN_CLICKED(IDC_BTN_PTZFocusin, &Cwin_demoDlg::OnBnClickedBtnPTZFocusIn)
	ON_BN_CLICKED(IDC_BTN_PTZFocusout, &Cwin_demoDlg::OnBnClickedBtnPTZFocusOut)
	ON_BN_CLICKED(IDC_BTN_PTZFocusAuto, &Cwin_demoDlg::OnBnClickedBtnPTZFocusAuto)
	ON_BN_CLICKED(IDC_BTN_CAPTURE, &Cwin_demoDlg::OnBnClickedBtnCapture)
	ON_BN_CLICKED(IDC_BTN_RECORD, &Cwin_demoDlg::OnBnClickedBtnRecord)
	ON_BN_CLICKED(IDC_BTN_STOP_RECORD, &Cwin_demoDlg::OnBnClickedBtnStopRecord)
	ON_BN_CLICKED(IDC_BUTTON_VIDEO_PARAM, &Cwin_demoDlg::OnBnClickedBtnVideoParam)
	ON_BN_CLICKED(IDC_BUTTON_OSD_PARAM, &Cwin_demoDlg::OnBnClickedBtnOSDParam)

	ON_BN_CLICKED(IDC_BTN_PTZ_IRIS_AUTO, &Cwin_demoDlg::OnBnClickedBtnPTZIrisAuto)
	ON_BN_CLICKED(IDC_BTN_PTZ_IRIS_IN, &Cwin_demoDlg::OnBnClickedBtnPTZIrisIn)
	ON_BN_CLICKED(IDC_BTN_PTZ_IRIS_OUT, &Cwin_demoDlg::OnBnClickedBtnPTZIrisOut)

	ON_BN_CLICKED(IDC_BTN_PTZ_ROTATE_U, &Cwin_demoDlg::OnBnClickedBtnPTZRotateU)
	ON_BN_CLICKED(IDC_BTN_PTZ_ROTATE_LU, &Cwin_demoDlg::OnBnClickedBtnPTZRotateLU)
	ON_BN_CLICKED(IDC_BTN_PTZ_ROTATE_L, &Cwin_demoDlg::OnBnClickedBtnPTZRotateL)
	ON_BN_CLICKED(IDC_BTN_PTZ_ROTATE_LD, &Cwin_demoDlg::OnBnClickedBtnPTZRotateLD)
	ON_BN_CLICKED(IDC_BTN_PTZ_ROTATE_D, &Cwin_demoDlg::OnBnClickedBtnPTZRotateD)
	ON_BN_CLICKED(IDC_BTN_PTZ_ROTATE_RD, &Cwin_demoDlg::OnBnClickedBtnPTZRotateRD)
	ON_BN_CLICKED(IDC_BTN_PTZ_ROTATE_R, &Cwin_demoDlg::OnBnClickedBtnPTZRotateR)
	ON_BN_CLICKED(IDC_BTN_PTZ_ROTATE_RU, &Cwin_demoDlg::OnBnClickedBtnPTZRotateRU)

	ON_BN_CLICKED(IDC_BUTTON_NET_PARAM, &Cwin_demoDlg::OnBnClickedBtnNetParam)
	ON_BN_CLICKED(IDC_BUTTON_PORT_PARAM, &Cwin_demoDlg::OnBnClickedBtnPortParam)

	ON_BN_CLICKED(IDC_BUTTON_ALARM_PARAM, &Cwin_demoDlg::OnBnClickedBtnAlarmParam)
	ON_BN_CLICKED(IDC_BUTTON_MULTIOBJ_PARAM, &Cwin_demoDlg::OnBnClickedBtnMultiobjParam)
	ON_BN_CLICKED(IDC_BUTTON_MAINTENANCE, &Cwin_demoDlg::OnBnClickedBtnMaintenance)
	ON_BN_CLICKED(IDC_BUTTON_THERMAL_PARAM, &Cwin_demoDlg::OnBnClickedBtnThermalParam)
	ON_BN_CLICKED(IDC_BTN_PLAYBACK, &Cwin_demoDlg::OnBnClickedBtnPlayback)
	ON_WM_CLOSE()
END_MESSAGE_MAP()


BOOL Cwin_demoDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);

	m_ip.SetWindowTextA("1.1.1.1");
	m_port.SetWindowTextA("32021");	
	m_user.SetWindowTextA("admin");
	m_passwd.SetWindowTextA("admin");
	m_chn.SetWindowTextA("1");
	m_cb_v_stream_type.AddString(TEXT("Main stream"));
	m_cb_v_stream_type.AddString(TEXT("Sub stream"));
	m_cb_v_stream_type.SetCurSel(0);
	return TRUE;
}

void Cwin_demoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

void Cwin_demoDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this);

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

HCURSOR Cwin_demoDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void Cwin_demoDlg::OnEnChangeEditIp()
{

}
int m_chn_option = 0;
int m_handle = 0;
//int m_handle1;
int m_stream_id = 0;
int restart_live_flag = 0;
int restart_con = 0;
char m_conn_ip[16] = { 0 };
int m_conn_port = 0;
char m_conn_user[128] = { 0 };
char m_conn_passwd[128] = { 0 };
static sys_thread_t *p_thread = NULL;
int run = 1;
static void disconn_cb_func(unsigned int handle, void* p_obj, int type)
{
#if 1
	printf("disconn callback,handle[%d] type[%d]\n", handle, type);
	if (type == 2)
	{
		printf("m_stream_id[%d]\n", m_stream_id);
		restart_live_flag = 1;
	}
	if (type == 1)
	{
		restart_con = 1;
	}
#endif
}


int restart_routine(void *p_param, int *p_run)
{
	while (1)
	{
		if (1 == restart_live_flag)
		{
			sdks_md_live_stop(m_handle, m_stream_id);
			HWND hwnd = m_video.GetSafeHwnd();
			int ii = 0;
			do
			{
				m_stream_id = sdks_md_live_start(m_handle, 1, STREAM_TYPE_1, hwnd, true, NULL, NULL);
			} while (m_stream_id <= 0 && (ii++ < 5));
			if (m_stream_id > 0)
			{
				restart_live_flag = 0;
			}
		}

		if (1 == restart_con)
		{
			int yy = 0;
			sdks_dev_conn_close(m_handle);
			sdks_md_live_stop(m_handle, m_stream_id);
			m_handle = 0;
			do
			{
				m_handle = sdks_dev_conn(m_conn_ip, m_conn_port, m_conn_user, m_conn_passwd, disconn_cb_func, NULL);
			} while (m_handle <= 0 && (yy++ < 5));

			if (m_handle > 0)
			{
				HWND hwnd = m_video.GetSafeHwnd();
				m_stream_id = sdks_md_live_start(m_handle, 1, STREAM_TYPE_1, hwnd, true, NULL, NULL);
				restart_con = 0;
			}
			else
			{
				sys_sleep(1000 * 2);
			}


		}
		sys_sleep(100);
	}
}

void Cwin_demoDlg::OnBnClickedBtnVideoParam()
{
	CString strins;
	m_chn.GetWindowText(strins);
	m_chn_option = _ttoi(strins);
	CDialogStreamParam *pDlgStreamParam = new CDialogStreamParam;
	pDlgStreamParam->Create(IDD_WIN_STREAM_PARAM, this);
	pDlgStreamParam->ShowWindow(SW_SHOW);
	pDlgStreamParam->OnInitStreamParam();
}

void Cwin_demoDlg::OnBnClickedBtnOSDParam()
{
	CString strins;
	m_chn.GetWindowText(strins);
	m_chn_option = _ttoi(strins);
	CDialogOSDParam *pDlgOSDParam = new CDialogOSDParam;
	pDlgOSDParam->Create(IDD_WIN_OSD_PARAM, this);
	pDlgOSDParam->ShowWindow(SW_SHOW);
	pDlgOSDParam->OnInitOSDParam();
}

void Cwin_demoDlg::OnBnClickedBtnNetParam()
{
	CString strins;
	m_chn.GetWindowText(strins);
	m_chn_option = _ttoi(strins);
	CDialogNetParam *pDlgNetParam = new CDialogNetParam;
	pDlgNetParam->Create(IDD_DIALOG_NET_PARAM, this);
	pDlgNetParam->ShowWindow(SW_SHOW);
	pDlgNetParam->OnInitNetParam();
}

void Cwin_demoDlg::OnBnClickedBtnPortParam()
{
	CString strins;
	m_chn.GetWindowText(strins);
	m_chn_option = _ttoi(strins);
	CDialogPortParam *pDlgPortParam = new CDialogPortParam;
	pDlgPortParam->Create(IDD_DIALOG_PORT_PARAM, this);
	pDlgPortParam->ShowWindow(SW_SHOW);
	pDlgPortParam->OnInitPortParam();
}

void Cwin_demoDlg::OnBnClickedBtnAlarmParam()
{
	CString strins;
	m_chn.GetWindowText(strins);
	m_chn_option = _ttoi(strins);
	CDialogAlarmParam *pDlgAlarmParam = new CDialogAlarmParam;
	pDlgAlarmParam->Create(IDD_DIALOG_ALARM_PARAM, this);
	pDlgAlarmParam->ShowWindow(SW_SHOW);
	pDlgAlarmParam->OnInitAlarmParam();
}

void Cwin_demoDlg::OnBnClickedBtnMultiobjParam()
{
	CString strins;
	m_chn.GetWindowText(strins);
	m_chn_option = _ttoi(strins);
	CDialogMultiobjParam *pDlgMultiobjParam = new CDialogMultiobjParam;
	pDlgMultiobjParam->Create(IDD_DIALOG_MULTIOBJ_PARAM, this);
	pDlgMultiobjParam->ShowWindow(SW_SHOW);
	pDlgMultiobjParam->OnInitMultiobjParam();
}

void Cwin_demoDlg::OnBnClickedBtnThermalParam()
{
	CString strins;
	m_chn.GetWindowText(strins);
	m_chn_option = _ttoi(strins);
	CDialogThermalParam *pDlgThermalParam = new CDialogThermalParam;
	pDlgThermalParam->Create(IDD_DIALOG_THERMAL_PARAM, this);
	pDlgThermalParam->ShowWindow(SW_SHOW);
	pDlgThermalParam->OnInitThermalParam();
	pDlgThermalParam->OnInitThermalArea();
}

void Cwin_demoDlg::OnBnClickedBtnMaintenance()
{
	CString strins;
	m_chn.GetWindowText(strins);
	m_chn_option = _ttoi(strins);
	CDialogMaintenance *pDlgMaintenance = new CDialogMaintenance;
	pDlgMaintenance->Create(IDD_DIALOG_MAINTENANCE, this);
	pDlgMaintenance->ShowWindow(SW_SHOW);
	pDlgMaintenance->OnInitMaintenance();
}

void Cwin_demoDlg::OnBnClickedBtnCon()
{
	CString str_host;
	CString str_port;
	CString str_user;
	CString str_passwd;
	m_ip.GetWindowTextA(str_host);
	m_port.GetWindowTextA(str_port);
	m_user.GetWindowTextA(str_user);
	m_passwd.GetWindowTextA(str_passwd);

	if (("" == str_host) || ("" == str_port) || ("" == str_user) || ("" == str_passwd))
	{
		MessageBoxA("Parameter error!");
		return;
	}

	m_handle = sdks_dev_conn(str_host, atoi(str_port), str_user, str_passwd, disconn_cb_func, NULL);
	if (m_handle == 0)
	{
		MessageBoxA("Connect host failed!");
		return;
	}
	else
	{
		memcpy(m_conn_ip, str_host, str_host.GetLength());
		m_conn_port = atoi(str_port);
		memcpy(m_conn_user, str_user, str_user.GetLength());
		memcpy(m_conn_passwd, str_passwd, str_passwd.GetLength());
	}
	//m_handle1 = sdks_dev_conn(str_host, atoi(str_port), str_user, str_passwd, disconn_cb_func, NULL);
	if (p_thread == NULL)
	{
		p_thread = sys_thread_create(restart_routine, NULL, &run);
	}
	sdks_dev_open_ptz(m_handle);
	UpdateSurface();
}


void Cwin_demoDlg::OnBnClickedBtnPlay()
{
	int nStreamType = m_cb_v_stream_type.GetCurSel();
	if (1 == nStreamType){
		nStreamType = STREAM_TYPE_2;	//sub stream
	} else {
		nStreamType = STREAM_TYPE_1;	//main stream
	}
	CString str_chn;
	m_chn.GetWindowTextA(str_chn);
	HWND hwnd = m_video.GetSafeHwnd();
	m_stream_id = sdks_md_live_start(m_handle, atoi(str_chn), nStreamType, hwnd, true, NULL, NULL);
	sdks_md_audio_start(m_handle, m_stream_id);
	if (m_stream_id >= 0)
	{
		m_mainplay.EnableWindow(FALSE);
		m_mainstop.EnableWindow(TRUE);
	}
}

void Cwin_demoDlg::OnBnClickedBtnStop()
{
	if (m_stream_id)
	{
		sdks_md_audio_stop(m_handle, m_stream_id);
		sdks_md_live_stop(m_handle, m_stream_id);
		m_stream_id = 0;
		CRect rectDlg;
		GetClientRect(rectDlg);
		int pointWidth = rectDlg.Width();
		int pointHeight = rectDlg.Height();
		RedrawWindow(CRect(0, 0, pointWidth, pointHeight));
	}
	m_mainplay.EnableWindow(TRUE);
	m_mainstop.EnableWindow(FALSE);
}

void Cwin_demoDlg::OnBnClickedBtnClose()
{
	sdks_dev_close_ptz(m_handle);
	OnBnClickedBtnStop();
	sdks_dev_conn_close(m_handle);
	m_handle = 0;
	UpdateSurface();
}

void Cwin_demoDlg::UpdateSurface()
{
	if (m_handle > 0)
	{
		m_connnect.EnableWindow(FALSE);
		m_close.EnableWindow(TRUE);
		m_mainplay.EnableWindow(TRUE);
		m_mainstop.EnableWindow(FALSE);
		m_ptzzoomin.EnableWindow(TRUE);
		m_ptzzoomout.EnableWindow(TRUE);
		m_ptzfocusin.EnableWindow(TRUE);
		m_ptzfocusout.EnableWindow(TRUE);
		m_ptzfocusauto.EnableWindow(TRUE);
		m_cb_v_stream_type.EnableWindow(TRUE);
		m_capture.EnableWindow(TRUE);
		m_record.EnableWindow(TRUE);
		m_stop_record.EnableWindow(FALSE);
		m_video_param.EnableWindow(TRUE);
		m_osd_param.EnableWindow(TRUE);
		m_save_record.EnableWindow(TRUE);
		m_ptz_iris_auto.EnableWindow(TRUE);
		m_ptz_iris_in.EnableWindow(TRUE);
		m_ptz_iris_out.EnableWindow(TRUE);
		m_ptz_rotate_u.EnableWindow(TRUE);
		m_ptz_rotate_ru.EnableWindow(TRUE);
		m_ptz_rotate_r.EnableWindow(TRUE);
		m_ptz_rotate_rd.EnableWindow(TRUE);
		m_ptz_rotate_d.EnableWindow(TRUE);
		m_ptz_rotate_ld.EnableWindow(TRUE);
		m_ptz_rotate_l.EnableWindow(TRUE);
		m_ptz_rotate_lu.EnableWindow(TRUE);
		m_net_param.EnableWindow(TRUE);
		m_port_param.EnableWindow(TRUE);
		m_alarm_param.EnableWindow(TRUE);
		m_multiobj_param.EnableWindow(TRUE);
		m_maintenance.EnableWindow(TRUE);
		m_thermal_param.EnableWindow(TRUE);
		m_btn_playback.EnableWindow(TRUE);
	}
	else
	{
		m_connnect.EnableWindow(TRUE);
		m_close.EnableWindow(FALSE);
		m_mainplay.EnableWindow(FALSE);
		m_mainstop.EnableWindow(FALSE);
		m_ptzzoomin.EnableWindow(FALSE);
		m_ptzzoomout.EnableWindow(FALSE);
		m_ptzfocusin.EnableWindow(FALSE);
		m_ptzfocusout.EnableWindow(FALSE);
		m_ptzfocusauto.EnableWindow(FALSE);
		m_cb_v_stream_type.EnableWindow(FALSE);
		m_capture.EnableWindow(FALSE);
		m_record.EnableWindow(FALSE);
		m_stop_record.EnableWindow(FALSE);
		m_video_param.EnableWindow(FALSE);
		m_osd_param.EnableWindow(FALSE);
		m_save_record.EnableWindow(FALSE);
		m_ptz_iris_auto.EnableWindow(FALSE);
		m_ptz_iris_in.EnableWindow(FALSE);
		m_ptz_iris_out.EnableWindow(FALSE);
		m_ptz_rotate_u.EnableWindow(FALSE);
		m_ptz_rotate_ru.EnableWindow(FALSE);
		m_ptz_rotate_r.EnableWindow(FALSE);
		m_ptz_rotate_rd.EnableWindow(FALSE);
		m_ptz_rotate_d.EnableWindow(FALSE);
		m_ptz_rotate_ld.EnableWindow(FALSE);
		m_ptz_rotate_l.EnableWindow(FALSE);
		m_ptz_rotate_lu.EnableWindow(FALSE);
		m_net_param.EnableWindow(FALSE);
		m_port_param.EnableWindow(FALSE);
		m_alarm_param.EnableWindow(FALSE);
		m_multiobj_param.EnableWindow(FALSE);
		m_maintenance.EnableWindow(FALSE);
		m_thermal_param.EnableWindow(FALSE);
		m_btn_playback.EnableWindow(FALSE);
	}
}

void Cwin_demoDlg::OnBnClickedBtnPTZZoomIn()
{
	sdks_dev_ptz_zoom(m_handle, 1, 9, 32);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZZoomOut()
{
	sdks_dev_ptz_zoom(m_handle, 1, 10, 32);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZFocusIn()
{
	sdks_dev_ptz_focus(m_handle, 1, 12);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZFocusOut()
{
	sdks_dev_ptz_focus(m_handle, 1, 11);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZFocusAuto()
{
	sdks_dev_ptz_focus(m_handle, 1, 24);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZIrisAuto()
{
	sdks_dev_ptz_iris(m_handle, 1, 24);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZIrisIn()
{
	sdks_dev_ptz_iris(m_handle, 1, 12);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZIrisOut()
{
	sdks_dev_ptz_iris(m_handle, 1, 11);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZRotateU()
{
	sdks_dev_ptz_rotate(m_handle, 1, 1, 32);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZRotateLU()
{
	sdks_dev_ptz_rotate(m_handle, 1, 5, 32);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZRotateL()
{
	sdks_dev_ptz_rotate(m_handle, 1, 3, 32);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZRotateLD()
{
	sdks_dev_ptz_rotate(m_handle, 1, 6, 32);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZRotateD()
{
	sdks_dev_ptz_rotate(m_handle, 1, 2, 32);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZRotateRD()
{
	sdks_dev_ptz_rotate(m_handle, 1, 8, 32);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZRotateR()
{
	sdks_dev_ptz_rotate(m_handle, 1, 4, 32);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

void Cwin_demoDlg::OnBnClickedBtnPTZRotateRU()
{
	sdks_dev_ptz_rotate(m_handle, 1, 7, 32);
	Sleep(200);
	sdks_dev_ptz_stop(m_handle, 1);
}

FILE* g_pfile = NULL;
int g_rec_id = 0;
bool bSingleSave = false;
void stream_cb(unsigned int handle, int stream_id, void* p_data, void* p_obj)
{
	if (bSingleSave)
	{
		if (NULL == g_pfile)
		{
			g_pfile = fopen("F:\\data\\test.h264", "wb+");
		}

		if (NULL != g_pfile)
		{
			ST_AVFrameData* p_frame = (ST_AVFrameData*)p_data;
			if (2 == p_frame->nESStreamType)
			{
				return;
			}

			if ((NULL != p_frame) && (p_frame->nDataLength > 0))
			{
				fwrite(p_frame->pszData, p_frame->nDataLength, 1, g_pfile);
				fflush(g_pfile);
			}
		}
	}else{
		ST_AVFrameData* p_frame = (ST_AVFrameData*)p_data;
		if (2 == p_frame->nESStreamType)
		{
			return;
		}
		if ((NULL != p_frame) && (p_frame->nDataLength > 0))
		{
			sdks_dev_record(g_rec_id, p_frame);
		}
	}
}

void Cwin_demoDlg::OnBnClickedBtnCapture()
{
	CString str_path;
	CString str_chn;
	char *p_snap_json = NULL;
	char *p_open_snap_json = NULL;
	m_filepath.GetWindowTextA(str_path);
	m_chn.GetWindowTextA(str_chn);
	if (("" == str_path) || ("" == str_chn))
	{
		MessageBoxA("File path is NULL!");
		return;
	}
	FILE  *file = fopen(str_path, "w+");
	if (NULL == file)
	{
		MessageBoxA("Snap picture file can't open!");
		return;
	}
	else
	{
		fclose(file);
	}
	jy_snap_picture_t stSnapParam;
	stSnapParam.channel_id = 1;
	stSnapParam.time_out = 2;
	stSnapParam.quality = 9;
	strcpy(stSnapParam.path, str_path);
	pack_json_open_snap(&stSnapParam, &p_open_snap_json);
	sdks_open_snap(m_handle, p_open_snap_json);
	pack_json_snap_picture(&stSnapParam, &p_snap_json);
	sdks_get_snap_picture(m_handle, p_snap_json);
	sdks_close_snap(m_handle, p_open_snap_json);
}

static int rec_stream_id = 0;
void Cwin_demoDlg::OnBnClickedBtnRecord()
{
	CString str_path;
	int nRet = 0;
	m_filepath.GetWindowTextA(str_path);

	if ("" == str_path)
	{
		MessageBoxA("File path is NULL!");
		return;
	}
	int nStreamType = m_cb_v_stream_type.GetCurSel();
	if (1 == nStreamType) {
		nStreamType = STREAM_TYPE_2;	//sub stream
	}
	else {
		nStreamType = STREAM_TYPE_1;	//main stream
	}
	rec_stream_id = sdks_dev_live_start(m_handle, 1, nStreamType, stream_cb, NULL);
	bSingleSave = false;
	if (((CButton*)GetDlgItem(IDC_CHECK_SAVE_RECOVE))->GetCheck() == TRUE)
	{
		bSingleSave = true;
	}
	else
	{
		g_rec_id = sdks_dev_open_rec(str_path, NULL);
	}

	m_record.EnableWindow(FALSE);
	m_save_record.EnableWindow(FALSE);
	m_stop_record.EnableWindow(TRUE);
	m_capture.EnableWindow(FALSE);
}

void Cwin_demoDlg::OnBnClickedBtnStopRecord()
{
	if (bSingleSave)
	{
		if (g_pfile)
		{
			fclose(g_pfile);
		}
		g_pfile = NULL;
	}
	else
	{
		sdks_dev_stop_rec(g_rec_id);
		g_rec_id = 0;
		sdks_dev_live_stop(m_handle, rec_stream_id);
	}	
	m_record.EnableWindow(TRUE);
	m_save_record.EnableWindow(TRUE);
	m_stop_record.EnableWindow(FALSE);
	m_capture.EnableWindow(TRUE);
}


void Cwin_demoDlg::OnBnClickedBtnPlayback()
{
	CString strins;
	m_chn.GetWindowText(strins);
	m_chn_option = _ttoi(strins);
	CDialogPlayback *pDlgPlayback = new CDialogPlayback;
	pDlgPlayback->Create(IDD_WIN_PLAYBACK, this);
	pDlgPlayback->ShowWindow(SW_SHOW);
	pDlgPlayback->OnInitPlayback();
}


void Cwin_demoDlg::OnClose()
{
	sdks_dev_close_ptz(m_handle);
	if (m_stream_id)
	{
		sdks_md_audio_stop(m_handle, m_stream_id);
		sdks_md_live_stop(m_handle, m_stream_id);
		m_stream_id = 0;
	}
	sdks_dev_conn_close(m_handle);
	m_handle = 0;
	CDialogEx::OnClose();
}
